/*
  LuxTag PixelFilter.js
  
  
*/

// global variables.
var version_num = "0.1";

var pixelFilter_types = ['mitchell', 'box', 'gaussian', 'sinc', 'triangle'];

function buildUI( tag ) {
	
	tag.addParameterSeparator("[ Pixel Filter ]");
	
	tag.addParameterSelector("pixel filter type", pixelFilter_types, false, false );
	
	tag.addParameterSeparator("common option");
	
	tag.addParameterFloat("xwidth", 2, 0, 10, true, false);
	tag.addParameterFloat("ywidth", 2, 0, 10, true, false);
	
	tag.addParameterSeparator("box option");
	tag.addParameterFloat("box::xwidth", 0.5, 0, 10, true, false);
	tag.addParameterFloat("box::ywidth", 0.5, 0, 10, true, false);
	
	tag.addParameterSeparator("gaussian option");
	tag.addParameterFloat("gaus::alpha", 2.0, 0, 10, true, false);
	
	tag.addParameterSeparator("mitchell option");
	tag.addParameterFloat("mitchell::sharpness", 0.3333, 0, 1.0, true, false);
	
	tag.addParameterSeparator("sinc option");
	tag.addParameterFloat("sinc::xwidth", 4.0, 0, 10, true, false);
	tag.addParameterFloat("sinc::ywidth", 4.0, 0, 10, true, false);
	tag.addParameterFloat("sinc::tau", 3.0, 0, 10, true, false);
	
}